<?xml version="1.0" encoding="UTF-8"?>
<!--Reference the file name as the href value-->
<?xml-stylesheet type="text/xsl" href="#"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://www.w3.org/1999/xhtml">
<!-- Output HTML doctype with text/html content-type and without XML declaration-->
<xsl:output method="xml" encoding="UTF-8" version="" indent="yes" standalone="no" media-type="text/html" omit-xml-declaration="yes" doctype-system="about:legacy-compat" />
<!-- Read the children of the stylesheet itself -->
<xsl:template match="xsl:stylesheet">
  <xsl:apply-templates/>
</xsl:template>
<!-- Output the HTML markup-->
<xsl:template match="/">
  <html>
    <head>
		<meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
		<style type="text/css">
			table {margin: 25px 10px 25px 10px; table-layout: fixed;  width:290mm;}
			table.obramowanie {border-collapse: collapse; border: 2px solid black; border-spacing:0px;  }					
			tr.obramowanie {border-collapse: collapse; border: 2px solid black; border-spacing:0px}					
			th, td {border-collapse: collapse; border: 1px solid black; border-spacing:0px; overflow: hidden;text-overflow: ellipsis; word-wrap: break-word}
			td.opis {width: 10%}
			th.opis {width: 10%}
			td.dane {font-weight: bold}
			td.daneCheck {font-weight: bold; text-align: center}
			td.daneId{font-weight: bold; background-color: silver; text-align: center}	
		</style>
    </head>
    <body>
	  <h2 style="text-align:center">FORMULARZ WNIOSKU O ZAWARCIE UMOWY O UDZIELANIE ŚWIADCZEŃ W ZPO</h2>	
      <!-- Read matching templates -->
	  <xsl:call-template name="DaneIdentyfikacyjne">
		<xsl:with-param name="daneIdent" select="//node()[local-name() = 'GSWUZ']"/>
	  </xsl:call-template>
	  <xsl:call-template name="wykazPodwykonawcow">
		<xsl:with-param name="podwyk" select="//node()[local-name() = 'komunikat']"/>
	  </xsl:call-template>
	  <xsl:if test="//node()[local-name()='LHMWU']">
		<xsl:call-template name="miejsca">
			<xsl:with-param name="miejsce" select="//node()[local-name() ='komunikat']"/>
		</xsl:call-template>
	  </xsl:if>
	  <xsl:if test="//node()[local-name()='BLKRH']">
		<xsl:call-template name="personel">
			<xsl:with-param name="personel" select="//node()[local-name()='komunikat']"/>
		</xsl:call-template>
	  </xsl:if>
	  <xsl:call-template name="szczegolyOferty">
		<xsl:with-param name='szczegoly' select="//node()[local-name() = 'LOFER']"/>
	  </xsl:call-template>
	  <xsl:if test="//node()[local-name()='LHWSS']">
		<xsl:call-template name="sprzet">
			<xsl:with-param name="sprzet" select="//node()[local-name()='komunikat']"/>
		</xsl:call-template>
	  </xsl:if>
      <!--<xsl:apply-templates />-->
    </body>
  </html>
</xsl:template>
<!-- Don't reprint text nodes within the xsl:stylesheet node -->
<xsl:template match="text()"/>
<!-- Read non-namespaced nodes within the xsl:stylesheet node -->
<xsl:template name="DaneIdentyfikacyjne">
	<xsl:param name="daneIdent" />
	<table class="obramowanie">
		<tr>						
			<td style="border: 0px; height: 0; width: 45mm"></td> 
			<td style="border: 0px; height: 0; width: 45%"></td> 
			<td style="border: 0px; height: 0; width: 5%"></td> 
			<td style="border: 0px; height: 0; width: 45mm%"></td> 
			<td style="border: 0px; height: 0"></td> 						
		</tr>
		<tr class="obramowanie">
			<th colspan="5">I. DANE IDENTYFIKACYJNE WNIOSKUJĄCEGO</th>
		</tr>				
		<tr class="obramowanie">
			<th style="border-collapse: collapse; border: 1px solid black; border-spacing:0px" colspan="5">Dane identyfikacyjne i adresowe wnioskodawcy - świadczeniodawcy w rozumieniu ustawy o świadczeniach opieki zdrowotnej finansowanych ze środków publicznych</th>
		</tr>
		<tr>
			<td>Nazwa</td><td colspan="4" class="dane"><xsl:value-of select="$daneIdent/@PNAZW"/></td>
		</tr>
		<tr>
			<td >Adres siedziby</td><td colspan="2" class="dane"><xsl:value-of select="$daneIdent/@ADRES"/></td>		
			<td >Kod terytorialny i nzawa</td><td class="dane"><xsl:value-of select="$daneIdent/@PTERYT"/></td>
		</tr>
		<tr>   
			<td>REGON</td><td class="dane" colspan="2"><xsl:value-of select="$daneIdent/@PWREG"/></td>
			<td>NIP</td><td class="dane"><xsl:value-of select="$daneIdent/@PWNIP"/></td>
		</tr>
		<tr>
			<td >Forma organizacyjno-prawna (czesc IV KR)</td><td colspan="4" class="dane"><xsl:value-of select="$daneIdent/@NFRP"/></td>
		</tr>
		<tr>
			<td>Osoba/y uprawniona do reprezentowania</td><td class="dane" colspan="2"><xsl:value-of select="$daneIdent/@DYRN"/></td>
			<td>Telefon</td><td class="dane"><xsl:value-of select="$daneIdent/@PTELE"/></td>
		</tr>
		<tr class="obramowanie">
			<th colspan="5">Dane rejestrowe</th>
		</tr>
		<xsl:for-each select="$daneIdent/*[local-name()='GHSWW']">
			<tr>
				<td>Rodzaj rejestru</td><td colspan="2" class="dane"><xsl:value-of select="@NORG"/></td>
				<td>Nr wpisu do rejestru</td><td class="dane"><xsl:value-of select="@NWPS"/></td>
			</tr>
			<tr>
				<td rowspan="2">Organ rejestrujący</td><td rowspan="2" colspan="2" class="dane"><xsl:value-of select="@NPRJ"/></td>						
				<td>Data wpisu</td><td class="dane">
					<xsl:if test="@DTWP != '0001-01-01'">
						<xsl:value-of select="@DTWP"/>
					</xsl:if>
				</td>
			</tr>
			<tr>						
				<td >Data ostatniej aktualizacji</td><td class="dane">
					<xsl:if test="@DTOM != '0001-01-01'">
						<xsl:value-of select="@DTOM"/>
					</xsl:if>
				</td>
			</tr>
		</xsl:for-each>
		<tr class="obramowanie">
			<th colspan="5">Certyfikaty</th>
		</tr>
		<tr>
			<td style="text-align:center">Nazwa</td>
			<td style="text-align:center" colspan="3">Zakres certyfikatu</td>
			<td style="text-align:center">Data ważności</td>
		</tr>
		<xsl:for-each select="$daneIdent/*[local-name()='GHSCR']">
			<tr>
				<td class="dane"><xsl:value-of select="@NCRT"/></td>
				<td colspan="3" class="dane"><xsl:value-of select="@ZCRT"/></td>
				<td class="dane"><xsl:value-of select="@DWAZ"/></td>
			</tr>
		</xsl:for-each>
	</table>	
  <xsl:apply-templates/>
</xsl:template>
<xsl:template name="szczegolyOferty">
	<xsl:param name="szczegoly"/>
	<table class="obramowanie">				
		<tr class="obramowanie">
			<th colspan="7">V. SZCZEGÓŁY WNIOSKU</th>
		</tr>				
		<xsl:for-each select="$szczegoly/*[local-name()='LSPOF']">				
			<xsl:for-each select="*[local-name()='LOZMW']">
				<tr class="obramowanie">
					<th colspan="7">OFERTA ASORTYMENTOWA</th>
				</tr>
				<xsl:variable name="LOZMW_IMWU" select="@IMWU"/>
				<tr>
					<td rowspan="5" class="daneId"><xsl:value-of select="//node()[local-name()='LHMWU'][@IMWU=$LOZMW_IMWU]/@IMWU"/></td>										
				</tr>
				<tr>
					<td>Nazwa miejsca udzielania świadczeń</td>										
					<td colspan="2" class="dane"><xsl:value-of select="//node()[local-name()='LHMWU'][@IMWU=$LOZMW_IMWU]/@NMWU"/></td>
					<td>Identyfikator grupy miejsc ocenianych łącznie</td>
					<td colspan="2" class="dane"><xsl:value-of select="../@KDGR"/></td>
				</tr>
				<tr>
					<td>Adres miejsca</td>
					<td colspan="2" class="dane"><xsl:value-of select="//node()[local-name()='LHMWU'][@IMWU=$LOZMW_IMWU]/@ADRES"/></td>
					<td>Kod terytorialny</td>
					<td colspan="2" class="dane"><xsl:value-of select="//node()[local-name()='LHMWU'][@IMWU=$LOZMW_IMWU]/@IGMN"/></td>
				</tr>
				<tr>
					<td>Kod komórki org. (część VII KR)</td>
					<td colspan="2" class="dane"><xsl:value-of select="//node()[local-name()='LHMWU'][@IMWU=$LOZMW_IMWU]/@REST"/></td>
					<td>Specjalność komórki org. (cz. VIII KR)</td>
					<td colspan="2" class="dane"><xsl:value-of select="//node()[local-name()='LHMWU'][@IMWU=$LOZMW_IMWU]/@OKSB"/></td>
				</tr>
				<tr class="obramowanie">
					<td>Kod przedmiotu postępowania</td>
					<td colspan="2" class="dane"><xsl:value-of select="../@PBUM"/></td>
					<td>Nazwa przedmiotu postępowania</td>
					<td colspan="2" class="dane" ><xsl:value-of select="../@NUSL"/></td>				
				</tr>	
				<xsl:choose>
					<xsl:when test="*[local-name()='LOFGP']">
						<xsl:variable name ="WORK_TIME">							
							<xsl:value-of select = "(sum( *[local-name()='LOFGP']/@GDKO ) - sum( *[local-name()='LOFGP']/@GDPO)) div 3600 "/>
						</xsl:variable>
						<tr class="obramowanie">
							<th colspan="7">Dostępność</th>
						</tr>
						<xsl:choose>
							<xsl:when test="$WORK_TIME=168">
								<tr>
									<td colspan="5">Dostępność zakresu</td>							
									<td class="dane" colspan="2">CAŁODOBOWO</td>
								</tr>	
							</xsl:when>
							<xsl:otherwise>
								<tr>
									<td colspan="5">Dostępność zakresu</td>							
									<td class="dane" colspan="2">WG HARMONOGRAMU</td>
								</tr>						
								<tr>
									<td>pon</td><td>wt</td><td>śr</td><td>czw</td><td>pt</td><td>sb</td><td>niedz</td>
								</tr>
								<tr>
									<td class="dane">									
										<xsl:for-each select="*[local-name()='LOFGP']">
											<xsl:if test="@DTYG=1">
												<xsl:value-of select="@CZAS"/><br/>
											</xsl:if>
										</xsl:for-each>										
									</td>
									<td class="dane">
										<xsl:for-each select="*[local-name()='LOFGP']">
											<xsl:if test="@DTYG=2">
												<xsl:value-of select="@CZAS"/><br/>
											</xsl:if>
										</xsl:for-each>
									</td>
									<td class="dane">
										<xsl:for-each select="*[local-name()='LOFGP']">
											<xsl:if test="@DTYG=3">
												<xsl:value-of select="@CZAS"/><br/>
											</xsl:if>
										</xsl:for-each>
									</td>
									<td class="dane">
										<xsl:for-each select="*[local-name()='LOFGP']">
											<xsl:if test="@DTYG=4">
												<xsl:value-of select="@CZAS"/><br/>
											</xsl:if>
										</xsl:for-each>
									</td>
									<td class="dane">
										<xsl:for-each select="*[local-name()='LOFGP']">
											<xsl:if test="@DTYG=5">
												<xsl:value-of select="@CZAS"/><br/>
											</xsl:if>
										</xsl:for-each>
									</td>
									<td class="dane">
										<xsl:for-each select="*[local-name()='LOFGP']">
											<xsl:if test="@DTYG=6">
												<xsl:value-of select="@CZAS"/><br/>
											</xsl:if>
										</xsl:for-each>
									</td>
									<td class="dane">
										 <xsl:for-each select="*[local-name()='LOFGP']">
											<xsl:if test="@DTYG=7">
												<xsl:value-of select="@CZAS"/><br/>
											</xsl:if>
										</xsl:for-each>
									</td>
								</tr>		
							</xsl:otherwise>
						</xsl:choose>						
					</xsl:when>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="*[local-name()='LOFLK']">
						<tr class="obramowanie">
							<th colspan="7">Personel</th>
						</tr>
						<xsl:for-each select="*[local-name()='LOFLK']">
							<xsl:variable name="LOFLK_ILKR" select="@ILKR"/>
							<tr>
								<td rowspan="3" class="daneId"><xsl:value-of select="//node()[local-name()='BLKRH'][@ILKR=$LOFLK_ILKR]/@LP"/></td>
							</tr>
							<tr>
								<td>Nazwisko</td>
								<td colspan="5" class="dane"><xsl:value-of select="//node()[local-name()='BLKRH'][@ILKR=$LOFLK_ILKR]/@NAZW"/></td>
							</tr>
							<tr>
								<td>Imiona</td>
								<td colspan="3" class="dane"><xsl:value-of select="//node()[local-name()='BLKRH'][@ILKR=$LOFLK_ILKR]/@IMIE"/></td>
								<td>PESEL</td>
								<td class="dane"><xsl:value-of select="//node()[local-name()='BLKRH'][@ILKR=$LOFLK_ILKR]/@WPSL"/></td>
							</tr>
							<tr>
								<td>Zawód/ specjalność</td>
								<td colspan="2" class="dane"><xsl:value-of select="@IDZN"/> - <xsl:value-of select="@NAZW_ZAW"/></td>
								<td>Stopień specjalizacji</td>
								<td class="dane"><xsl:value-of select="@STSP"/></td>
								<td>Nr Prawa Wyk. Zawodu</td>
								<td class="dane"><xsl:value-of select="@NPWZ"/></td>
							</tr>
							<tr>
								<td colspan="2">Stanowisko/funkcja pracownika</td>
								<td class="dane" colspan="3"><xsl:value-of select="@NSFO"/></td>
								<td>Liczba godzin pracy tygodniowo</td>
								<td class="dane"><xsl:value-of select="@WCZG"/>h <xsl:value-of select="@WCZM"/>m</td>
							</tr>
							<xsl:choose>
								<xsl:when test="*[local-name()='LOFGL']">
									<tr>
										<td>pon</td><td>wt</td><td>śr</td><td>czw</td><td>pt</td><td>sb</td><td>niedz</td>
									</tr>
									<tr>
										<td class="dane">									
											<xsl:for-each select="*[local-name()='LOFGL']">
												<xsl:if test="@DTYG=1">
													<xsl:value-of select="@CZAS"/><br/>
												</xsl:if>
											</xsl:for-each>
											<xsl:choose>
												<xsl:when test="*[local-name()='LOFGL']">
												</xsl:when>
												<xsl:otherwise>
													<br/>
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td class="dane">
											<xsl:for-each select="*[local-name()='LOFGL']">
												<xsl:if test="@DTYG=2">
													<xsl:value-of select="@CZAS"/><br/>
												</xsl:if>
											</xsl:for-each>
										</td>
										<td class="dane">
											<xsl:for-each select="*[local-name()='LOFGL']">
												<xsl:if test="@DTYG=3">
													<xsl:value-of select="@CZAS"/><br/>
												</xsl:if>
											</xsl:for-each>
										</td>
										<td class="dane">
											<xsl:for-each select="*[local-name()='LOFGL']">
												<xsl:if test="@DTYG=4">
													<xsl:value-of select="@CZAS"/><br/>
												</xsl:if>
											</xsl:for-each>
										</td>
										<td class="dane">
											<xsl:for-each select="*[local-name()='LOFGL']">
												<xsl:if test="@DTYG=5">
													<xsl:value-of select="@CZAS"/><br/>
												</xsl:if>
											</xsl:for-each>
										</td>
										<td class="dane">
											<xsl:for-each select="*[local-name()='LOFGL']">
												<xsl:if test="@DTYG=6">
													<xsl:value-of select="@CZAS"/><br/>
												</xsl:if>
											</xsl:for-each>
										</td>
										<td class="dane">
											 <xsl:for-each select="*[local-name()='LOFGL']">
												<xsl:if test="@DTYG=7">
													<xsl:value-of select="@CZAS"/><br/>
												</xsl:if>
											</xsl:for-each>
										</td>
									</tr>
								</xsl:when>
							</xsl:choose>
							<xsl:choose>
								<xsl:when test="//node()[local-name()='BLKRH'][@ILKR=$LOFLK_ILKR]/CDSZW">
									<tr class="obramowanie">
										<th colspan="7">Doświadczenie</th>
									</tr>
									<xsl:for-each select="//node()[local-name()='BLKRH'][@ILKR=$LOFLK_ILKR]/CDSZW">
										<tr>
											<td>Nazwa</td>
											<td class="dane" colspan="6"><xsl:value-of select="@NDZW"/></td>
										</tr>
									</xsl:for-each>
								</xsl:when>
							</xsl:choose>
							<xsl:choose>
								<xsl:when test="/komunikat/BLKRH[@ILKR=$LOFLK_ILKR]/CWKST">
									<tr class="obramowanie">
										<th colspan="7">Wykształcenie</th>
									</tr>
									<xsl:for-each select="/komunikat/BLKRH[@ILKR=$LOFLK_ILKR]/CWKST">
										<tr>
											<td>Nazwa</td>
											<td class="dane" colspan="6"><xsl:value-of select="@NWKS"/></td>
										</tr>
									</xsl:for-each>
								</xsl:when>
							</xsl:choose>
						</xsl:for-each>
					</xsl:when>
				</xsl:choose>
				<tr class="obramowanie">
					<th colspan="7">Zestaw produktów handlowych</th>
				</tr>
				<tr>
					<td colspan="4" style="text-align:center">Id zestawu produktów handlowych</td><td colspan="3" style="text-align:center">Wersja zestawu</td>
				</tr>
				<tr>
					<td colspan="4" class="dane"><xsl:value-of select="../@IGHA"/></td><td colspan="3" class="dane">-</td>
				</tr>
				<xsl:choose>
					<xsl:when test="*[local-name()='LHODS']">
						<tr class="obramowanie">
							<th colspan="7">Sprzęt</th>
						</tr>
						<xsl:for-each select="*[local-name()='LHODS']">
							<xsl:variable name="LHODS_IWSS" select="@IWSS"/>
							<tr>
								<td class="daneId"><xsl:value-of select="//node()[local-name()='LHWSS'][@IWSS=$LHODS_IWSS]/@LP"/></td>
								<td>Nazwa sprzętu</td>
								<td class="dane" colspan="3"><xsl:value-of select="//node()[local-name()='LHWSS'][@IWSS=$LHODS_IWSS]/@NAZW"/></td>
								<td>Ilość</td>
								<td class="dane"><xsl:value-of select="//node()[local-name()='LHWSS'][@IWSS=$LHODS_IWSS]/@ILOS"/></td>
							</tr>
							<tr>
								<td>Rodzaj dostępności sprzętu</td>
								<td class="dane"><xsl:value-of select="@LKSP"/></td>
								<td>Rok produkcji</td>
								<td class="dane"><xsl:value-of select="//node()[local-name()='LHWSS'][@IWSS=$LHODS_IWSS]/@ROKP"/></td>
								<td>Nr seryjny sprzętu</td>
								<td class="dane" colspan="2"><xsl:value-of select="//node()[local-name()='LHWSS'][@IWSS=$LHODS_IWSS]/@SERI"/></td>
							</tr>
						</xsl:for-each>
					</xsl:when>
				</xsl:choose>
				
				<xsl:choose>
					<xsl:when test="*[local-name()='LHODS1']">
						<tr class="obramowanie">
							<th colspan="7">Pojazdy</th>
						</tr>
						<xsl:for-each select="*[local-name()='LHODS1']">
							<xsl:variable name="LHODS_IWSS" select="@IWSS"/>
							<tr>
								<td class="daneId"><xsl:value-of select="//node()[local-name()='LHWSS'][@IWSS=$LHODS_IWSS]/@LP"/></td>
								<td>Nazwa pojazdu</td>
								<td class="dane" colspan="3"><xsl:value-of select="//node()[local-name()='LHWSS'][@IWSS=$LHODS_IWSS]/@NAZW"/></td>
								<td>Ilość</td>
								<td class="dane"><xsl:value-of select="//node()[local-name()='LHWSS'][@IWSS=$LHODS_IWSS]/@ILOS"/></td>
							</tr>
							<tr>
								<td>Rodzaj dostępności pojazdu</td>
								<td class="dane"><xsl:value-of select="//node()[local-name()='LHWSS'][@IWSS=$LHODS_IWSS]/@DOST"/></td>
								<td>Rok produkcji</td>
								<td class="dane"><xsl:value-of select="//node()[local-name()='LHWSS'][@IWSS=$LHODS_IWSS]/@ROKP"/></td>
								<td>Nr rejestracyjny</td>
								<td class="dane" colspan="2"><xsl:value-of select="//node()[local-name()='LHWSS'][@IWSS=$LHODS_IWSS]/@SERI"/></td>
							</tr>
						</xsl:for-each>
					</xsl:when>
				</xsl:choose>
			</xsl:for-each>					
		</xsl:for-each>				
	</table>
	<xsl:apply-templates />
</xsl:template>
<xsl:template name="wykazPodwykonawcow">	
		<xsl:param name="podwyk"/>
		<table class="obramowanie">
			<tr>
				<td style="border: 0px; height: 0%; width:160px"></td>
				<td style="border: 0px; height: 0%; width:40%"></td>
				<td style="border: 0px; height: 0%; width:25%"></td>
				<td style="border: 0px; height: 0%"></td>
			</tr>
			<tr>
				<th colspan="4">II. WYKAZ PODWYKONAWCÓW</th>
			</tr>
			<xsl:for-each select="$podwyk/*[local-name()='PODWYKONAWCA']">
				<tr>
					<td class="daneId">Unikalny wyróżnik podwykonawcy</td>
					<td class="dane" colspan="3"><xsl:value-of select="@ISWU"/></td>
				</tr>
				<tr class="obramowanie">
					<th colspan="4">Dane identyfikacyjne podwykonawcy</th>
				</tr>
				<tr>
					<td>Nazwa</td>
					<td class="dane" colspan="3"><xsl:value-of select="@PNAZW"/></td>
				</tr>
				<tr>
					<td>Adres siedziby</td>
					<td class="dane" colspan="3"><xsl:value-of select="@ADRES_PODM"/></td>
				</tr>
				<tr>
					<td>Kod terytorialny i nazwa</td>
					<td class="dane" colspan="3"><xsl:value-of select="@IGMN"/> <xsl:value-of select="concat(' ',@NGMN)"/></td>
				</tr>
				<tr>
					<td>REGON</td><td class="dane"><xsl:value-of select="@PWREG"/></td>
					<td>NIP</td><td class="dane"><xsl:value-of select="@PWNIP"/></td>
				</tr>
				<tr>
					<td>Forma organizacyjno-prawna (część IV KR)</td>
					<td class="dane" colspan="3"><xsl:value-of select="@NFRP"/></td>
				</tr>
				<tr>
					<td>Osoba/y uprawniona do reprezentowania</td><td class="dane"><xsl:value-of select="@DYRN"/></td>
					<td>Telefon</td><td class="dane"><xsl:value-of select="@PTELE"/></td>
				</tr>
				<tr class="obramowanie">
					<th colspan="4">Dane rejestrowe podwykonawcy</th>
				</tr>
				<xsl:for-each select="*[local-name()='GHSWW']">
					<tr>
						<td>Rodzaj rejestru</td><td class="dane"><xsl:value-of select="@NORG"/></td>
						<td>Nr wpisu do rejestru</td><td class="dane"><xsl:value-of select="@NWPS"/></td>
					</tr>
					<tr>
						<td rowspan="2">Organ rejestrujący</td><td rowspan="2" class="dane"><xsl:value-of select="@NPRJ"/></td>
						<td>Data wpisu</td><td class="dane">
							<xsl:if test="@DTWP != '0001-01-01'">
								<xsl:value-of select="@DTWP"/>
							</xsl:if>
						</td>
					</tr>
					<tr>						
						<td >Data ostatniej aktualizacji</td><td class="dane">
							<xsl:if test="@DTOM != '0001-01-01'">
								<xsl:value-of select="@DTOM"/>
							</xsl:if>
						</td>
					</tr>
				</xsl:for-each>
				<tr class="obramowanie">
					<th colspan="4">Dane dotyczące formy i przedmiotu umowy podwykonawstwa</th>
				</tr>		
				<xsl:for-each select="*[local-name()='LHUMP']">
					<tr>
						<td rowspan="2">Umowa/promesa</td><td rowspan="2" class="dane"><xsl:value-of select="@TUMP"/></td>
						<td>Data od kiedy obowiązuje lub będzie obowiązywać umowa</td><td class="dane"><xsl:value-of select="@DTPO"/></td>
					</tr>
					<tr>						
						<td>Data od kiedy obowiązuje lub będzie obowiązywać umowa</td><td class="dane"><xsl:value-of select="@DTKO"/></td>
					</tr>
					<tr>
						<!--<td colspan="4" style="border-spacing:0; border:0; padding: 0 0 0 0">
							<table style="margin: 0 0 0 0; border-spacing:0; width:100% border:0">
								<tr>-->
									<td style="width:160px; border: 0">Przedmiot świadczeń podwykonywanych</td><td class="dane" style="width:20%; border-top:0; border-bottom:0">
										<xsl:if test = "@ZUMW != ''">
											<xsl:value-of select="@ZUMW"/>
										</xsl:if>
										<xsl:if test = "@SUMW != ''">
											<xsl:value-of select="@SUMW"/>
										</xsl:if>
										<xsl:if test = "@UUMW != ''">
											<xsl:value-of select="@UUMW"/>
										</xsl:if>									
									</td>
									<td style="width:10%; border:0">Opis</td><td class="dane" style=" border-top:0; border-bottom:0">
										<xsl:if test = "@ZOPS != ''">
											<xsl:value-of select="@ZOPS"/>
										</xsl:if>
										<xsl:if test = "@SOPS != ''">
											<xsl:value-of select="@SOPS"/>
										</xsl:if>
										<xsl:if test = "@UOPS != ''">
											<xsl:value-of select="@UOPS"/>
										</xsl:if>
									</td>
								<!--</tr>
							</table>
						</td>-->
					</tr>
				</xsl:for-each>
			</xsl:for-each>
		</table>		
	<xsl:apply-templates/>
</xsl:template>
<xsl:template name="miejsca">
	<xsl:param name="miejsce"/>
	<table class="obramowanie">
		<tr>
			<th colspan="6">III. WYKAZ MIEJSC UDZIELANIA ŚWIADCZEŃ</th>
		</tr>
		<xsl:for-each select="$miejsce/*[local-name()='LHMWU']">
			<tr>
				<td class="daneId">UNIKALNY WYRÓŻNIK MIEJSCA</td><td class="dane"><xsl:value-of select="@IMWU"/></td>
				<td>Wyróżnik podwykonawcy</td><td class="dane"><xsl:value-of select="@ISWU"/></td>
				<td>Miejsce działania</td><td class="dane">
					<xsl:choose>
						<xsl:when test="@TMWU=0">
							stałe
						</xsl:when>
						<xsl:when test="@TMWU=1">
							mobilne
						</xsl:when>
						<xsl:when test="@TMWU=2">
							dom pacjenta
						</xsl:when>
						<xsl:when test="@TMWU=3">
							szkoła
						</xsl:when>
					</xsl:choose>							
				</td>
			</tr>
			<tr>
				<th colspan="6">Dane miejsca udzielania świadczeń</th>
			</tr>
			<tr>
				<td>Nazwa</td>
				<td class="dane" colspan="5"><xsl:value-of select="@NMWU"/></td>
			</tr>
			<tr>
				<td>Unikalny kod komórki org. (cz. VII KR)</td><td class="dane"><xsl:value-of select="@REST"/></td>
				<td>Specjalność komórki org. (cz. VIII KR)</td><td class="dane" colspan="3"><xsl:value-of select="@OKSB"/><xsl:value-of select="concat(' - ', @OKNZ)"/> </td>
			</tr>
			<tr>
				<th colspan="6">Lokalizacja</th>					
			</tr>
			<tr>
				<td>Adres</td><td class="dane" colspan="3"><xsl:value-of select="@ADRES"/></td>
				<td>Kod terytorialny</td><td class="dane"><xsl:value-of select="@IGMN"/></td>
			</tr>
			<tr>
				<th colspan="6">Dane profili medycznych miejsca udzielania świadczeń</th>
			</tr>
			<tr>
				<td class="daneId" style="font-weight:1">Unikalny wyróżnik profilu</td>
				<td>Kod profilu</td>
				<td colspan="4">Nazwa profilu</td>
			</tr>
			<xsl:for-each select="*[local-name()='LHMWP']">
				<tr>
					<td class="dane"><xsl:value-of select="@LP"/></td>
					<td class="dane"><xsl:value-of select="@KOD"/></td>
					<td class="dane" colspan="4"><xsl:value-of select="@NAZWA"/></td>
				</tr>
			</xsl:for-each>
		</xsl:for-each>
	</table>		
	<xsl:apply-templates/>
</xsl:template>
<xsl:template name="personel">
	<xsl:param name="personel"/>
	<table class="obramowanie">
		<tr style="text-align:center">
			<td style="border: 0px; height: 0%; width:80px"></td>
			<td style="border: 0px; height: 0%; width:100px"></td>
			<td style="border: 0px; height: 0%;"></td>
			<td style="border: 0px; height: 0%;"></td>
			<td style="border: 0px; height: 0%;"></td>
			<td style="border: 0px; height: 0%;"></td>
			<td style="border: 0px; height: 0%;"></td>
		</tr>
		<tr>
			<th colspan="7">IV. WYKAZ PERSONELU</th>
		</tr>
		<xsl:for-each select="$personel/*[local-name()='BLKRH']">
			<tr style="text-align:center">
				<td class="daneId" style="font-weight:1">Unikalny wyróżnik osoby</td>
				<td>PESEL</td>
				<td>Nazwisko</td>
				<td>Imiona</td>
				<td>Dostępny czy deklarowany</td>
				<td>Od kiedy pracownik będzie dostępny</td>
				<td>Miesięczny, średni godzinowy czas pracy</td>
			</tr>
			<tr>
				<td class="dane"><xsl:value-of select="@LP"/></td>
				<td class="dane"><xsl:value-of select="@WPSL"/></td>
				<td class="dane"><xsl:value-of select="@NAZW"/></td>
				<td class="dane"><xsl:value-of select="@IMIE"/></td>
				<td class="dane"><xsl:value-of select="@DOS_DEK"/></td>
				<td class="dane"><xsl:value-of select="@OD_KIEDY"/></td>
				<td class="dane"><xsl:value-of select="@SMCG"/>h 
					<xsl:if test="@SMCM > 0">
						<xsl:value-of select="@SMCM"/>m
					</xsl:if>
				</td>
			</tr>
			<tr>
				<th colspan="7">Uprawnienia zawodowe</th>
			</tr>
			<tr style="text-align:center">
				<td colspan="5">Grupa zawodowa</td>
				<td colspan="2">Nr Prawa Wyk. Zawodu</td>
			</tr>
			<xsl:for-each select="*[local-name()='LHUZO']">
				<tr>
					<td colspan="5" class="dane"><xsl:value-of select="@NRUP"/></td>
					<td colspan="2" class="dane"><xsl:value-of select="@NPWZ"/></td>
				</tr>
			</xsl:for-each>
			<tr>
				<th colspan="7">Zawody/specjalności</th>
			</tr>
			<tr style="text-align:center">
				<td colspan="3">Nazwa</td>
				<td colspan="2">Stopień specjalności</td>
				<td>Data uzyskania</td>		
				<td>Data otwarcia</td>
			</tr>
			<xsl:for-each select="*[local-name()='CSPLK']">
				<tr>
					<td colspan="3" class="dane"><xsl:value-of select="@NSPL"/></td>
					<td colspan="2" class="dane"><xsl:value-of select="@STSP"/></td>
					<td class="dane"><xsl:value-of select="@DTUZ"/></td>
					<td class="dane"><xsl:value-of select="@DTOT"/></td>
				</tr>
			</xsl:for-each>
			<tr>
				<th colspan="7">Doświadczenie zawodowe</th>
			</tr>
			<xsl:for-each select="*[local-name()='CDSZW']">		
				<tr>
					<td>Nazwa</td>
					<td class="dane" colspan="6"><xsl:value-of select="@NDZW"/></td>
				</tr>
			</xsl:for-each>
			<tr>
				<th colspan="7">Wykształcenie</th>
			</tr>
			<xsl:for-each select="*[local-name()='CWKST']">		
				<tr>
					<td>Nazwa</td>
					<td class="dane" colspan="6"><xsl:value-of select="@NWKS"/></td>
				</tr>
			</xsl:for-each>
		</xsl:for-each>
	</table>
	<xsl:apply-templates/>
</xsl:template>
<xsl:template name="sprzet">
	<xsl:param name="sprzet"/>
		<div class="landscape" style="font-size:12px">
			<table class="obramowanie" style="width:295mm">
				<tr>
					<td style="border: 0px; height: 0%; width:60px"></td>
					<td style="border: 0px; height: 0%; width:80px"></td>
					<td style="border: 0px; height: 0%; width:220px"></td>
					<td style="border: 0px; height: 0%; width:50px"></td>
					<td style="border: 0px; height: 0%; width:80px"></td>
					<td style="border: 0px; height: 0%; width:80px"></td>
					<td style="border: 0px; height: 0%; width:80px"></td>
					<td style="border: 0px; height: 0%; width:80px"></td>
					<td style="border: 0px; height: 0%; width:80px"></td>
					<td style="border: 0px; height: 0%; width:80px"></td>
					<td style="border: 0px; height: 0%; width:80px"></td>
					<td style="border: 0px; height: 0%;"></td>	
				</tr>
				<tr>
					<th colspan="12">VI. WYKAZ SPRZETU I POJAZDÓW</th>
				</tr>
				<tr style="text-align:center">
					<td class="daneId" style="font-weight:0">Unikalny wyróżnik sprzętu i pojazdów</td>
					<td>Unikallny wyróżnik podwykonawcy</td>
					<td>Nazwa sprzętu i pojazdów</td>
					<td>Ilość</td>
					<td>Model</td>
					<td>Nr seryjny/Nr rejestracyjny</td>
					<td>Rok produkcji</td>
					<td>Status</td>
					<td>Data uzyskania</td>
					<td>Kod UMDNS</td>
					<td>Umowa serwisowa</td>
					<td>Dostępność dla innych komórek</td>
				</tr>
				<xsl:for-each select="$sprzet/*[local-name()='LHWSS']">
					<tr>
						<td class="dane"><xsl:value-of select="@LP"/></td>
						<td class="dane"><xsl:value-of select="@IDPD"/></td>
						<td class="dane"><xsl:value-of select="@NAZW"/></td>
						<td class="dane"><xsl:value-of select="@ILOS"/></td>
						<td class="dane"><xsl:value-of select="@SMOD"/></td>
						<td class="dane"><xsl:value-of select="@SERI"/></td>
						<td class="dane"><xsl:value-of select="@ROKP"/></td>
						<td class="dane">
							<xsl:choose>
								<xsl:when test="@POSD=1">
									POSIADAM
								</xsl:when>
								<xsl:otherwise>
									BĘDĘ POSIADAŁ
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="dane"><xsl:value-of select="@DPOS"/></td>
						<td class="dane"><xsl:value-of select="@UMDN"/></td>								
						<td class="dane">
							<xsl:choose>
								<xsl:when test="@SERW=1">
									TAK
								</xsl:when>
								<xsl:otherwise>
									NIE
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="dane"><xsl:value-of select="@DOST"/></td>	
					</tr>
				</xsl:for-each>
			</table>
		</div>
	<xsl:apply-templates/>
</xsl:template>

</xsl:stylesheet> 